/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.torohealth.bars;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.torocraft.torohealth.ToroHealth;
import net.torocraft.torohealth.bars.BarParticle;
import net.torocraft.torohealth.bars.BarStates;
import net.torocraft.torohealth.bars.HealthBarRenderer;

public class ParticleRenderer {
    public static void renderParticles(PoseStack matrix, Camera camera, MultiBufferSource bufferSource) {
        for (BarParticle p : BarStates.PARTICLES) {
            ParticleRenderer.renderParticle(matrix, p, camera, bufferSource);
        }
    }

    private static void renderParticle(PoseStack matrix, BarParticle particle, Camera camera, MultiBufferSource bufferSource) {
        double distanceSquared = camera.m_90583_().m_82531_(particle.x, particle.y, particle.z);
        if (distanceSquared > (double)ToroHealth.CONFIG.particle.distanceSquared) {
            return;
        }
        float scaleToGui = 0.025f;
        Minecraft client = Minecraft.m_91087_();
        float tickDelta = client.m_91297_();
        double x = Mth.m_14139_((double)tickDelta, (double)particle.xPrev, (double)particle.x);
        double y = Mth.m_14139_((double)tickDelta, (double)particle.yPrev, (double)particle.y);
        double z = Mth.m_14139_((double)tickDelta, (double)particle.zPrev, (double)particle.z);
        Vec3 camPos = camera.m_90583_();
        double camX = camPos.f_82479_;
        double camY = camPos.f_82480_;
        double camZ = camPos.f_82481_;
        matrix.m_85836_();
        matrix.m_85837_(x - camX, y - camY, z - camZ);
        matrix.m_252781_(Axis.f_252436_.m_252977_(-camera.m_90590_()));
        matrix.m_252781_(Axis.f_252529_.m_252977_(camera.m_90589_()));
        matrix.m_85841_(-scaleToGui, -scaleToGui, scaleToGui);
        RenderSystem.setShader(GameRenderer::m_172811_);
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        HealthBarRenderer.drawDamageNumber(matrix, bufferSource, particle.damage, 0.0, 0.0, 10.0f);
        RenderSystem.disableBlend();
        matrix.m_85849_();
    }
}

